<?php
session_start();
include 'conexao.php';

// Apenas Subdireção Pedagógica
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$mensagem = '';
$tipo_mensagem = '';
$ano_lectivo_atual = "2025/2026";

// Extrai os anos civis do ano letivo
$ano1 = substr($ano_lectivo_atual, 0, 4); // Ex: 2025
$ano2 = substr($ano_lectivo_atual, 5, 4); // Ex: 2026

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $trimestre = (int)($_POST['trimestre'] ?? 0);
    $tipo_nota = $_POST['tipo_nota'] ?? '';
    $dia_inicio = (int)($_POST['dia_inicio'] ?? 0);
    $dia_fim = (int)($_POST['dia_fim'] ?? 0);
    $mes_inicio = (int)($_POST['mes_inicio'] ?? 0);
    $mes_fim = (int)($_POST['mes_fim'] ?? 0);

    if ($trimestre > 0 && $tipo_nota !== '' && $dia_inicio > 0 && $dia_fim > 0 && $mes_inicio > 0 && $mes_fim > 0) {

        // Determinar o ano civil correto
        $ano_inicio = ($mes_inicio >= 9 && $mes_inicio <= 12) ? $ano1 : $ano2;
        $ano_fim = ($mes_fim >= 9 && $mes_fim <= 12) ? $ano1 : $ano2;

        $data_inicio = "{$ano_inicio}-" . str_pad($mes_inicio, 2, '0', STR_PAD_LEFT) . "-" . str_pad($dia_inicio, 2, '0', STR_PAD_LEFT);
        $data_fim = "{$ano_fim}-" . str_pad($mes_fim, 2, '0', STR_PAD_LEFT) . "-" . str_pad($dia_fim, 2, '0', STR_PAD_LEFT);

        try {
            $timestamp_inicio = strtotime($data_inicio);
            $timestamp_fim = strtotime($data_fim);

            if (!$timestamp_inicio || !$timestamp_fim) {
                throw new Exception("Data inválida. Verifique o dia e mês selecionados.");
            }

            if ($timestamp_inicio >= $timestamp_fim) {
                throw new Exception("A data de início deve ser anterior à data de fim.");
            }

            // Inserção na base de dados
            $stmt = $conn->prepare("
                INSERT INTO prazos_lancamento
                (ano_lectivo, trimestre, tipo_nota, data_inicio, data_fim)
                VALUES (?, ?, ?, ?, ?)
            ");

            $stmt->bind_param(
                "sisss",
                $ano_lectivo_atual,
                $trimestre,
                $tipo_nota,
                $data_inicio,
                $data_fim
            );
            $stmt->execute();

            $meses_pt = [1=>'Janeiro',2=>'Fevereiro',3=>'Março',4=>'Abril',5=>'Maio',6=>'Junho',7=>'Julho',8=>'Agosto',9=>'Setembro',10=>'Outubro',11=>'Novembro',12=>'Dezembro'];
            $nome_mes_inicio = $meses_pt[$mes_inicio];
            $nome_mes_fim = $meses_pt[$mes_fim];

            $mensagem = "✅ Prazo definido com sucesso!<br>
                         Lançamento de <b>$tipo_nota</b> (Trimestre $trimestre) disponível de
                         <b>$dia_inicio/$nome_mes_inicio/$ano_inicio</b> até <b>$dia_fim/$nome_mes_fim/$ano_fim</b>.";
            $tipo_mensagem = 'success';

        } catch (Exception $e) {
            $mensagem = "❌ Erro ao salvar prazo: " . $e->getMessage();
            $tipo_mensagem = 'error';
        }
    } else {
        $mensagem = "Preencha todos os campos corretamente.";
        $tipo_mensagem = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Definir Prazos de Lançamento</title>
<style>
    body { font-family: Arial, sans-serif; background:#f4f7f9; margin:0; padding:0; }
    .container { max-width:600px; margin:50px auto; background:#fff; padding:25px; border-radius:10px; box-shadow:0 0 15px rgba(0,0,0,.1); }
    h2 { text-align:center; margin-bottom:25px; }
    .form-group { margin-bottom:20px; }
    label { font-weight:bold; display:block; margin-bottom:5px; }
    select, input, button { width:100%; padding:12px; border-radius:6px; border:1px solid #ccc; box-sizing:border-box; font-size:1rem; }
    button { background:#007bff; color:#fff; border:none; cursor:pointer; transition:0.3s; font-weight:bold; }
    button:hover { background:#0056b3; }
    .alert { padding:12px; border-radius:6px; font-weight:bold; margin-bottom:15px; }
    .success { background:#d4edda; color:#155724; }
    .error { background:#f8d7da; color:#721c24; }
    h4 { margin:10px 0; }
    @media(max-width:480px){ .container{padding:15px;} }
</style>
</head>
<body>

<div class="container">

<h2>Definir Prazo de Lançamento (Ano Letivo: <?= $ano_lectivo_atual ?>)</h2>

<?php if($mensagem): ?>
<div class="alert <?= $tipo_mensagem ?>"><?= $mensagem ?></div>
<?php endif; ?>

<form method="POST">

    <div class="form-group">
        <label>Trimestre:</label>
        <select name="trimestre" required>
            <option value="">-- Escolha --</option>
            <option value="1">1º Trimestre</option>
            <option value="2">2º Trimestre</option>
            <option value="3">3º Trimestre</option>
        </select>
    </div>

    <div class="form-group">
        <label>Tipo de Nota:</label>
        <select name="tipo_nota" required>
            <option value="">-- Escolha --</option>
            <option value="MAC">MAC (Média de Avaliação Contínua)</option>
            <option value="NPP">NPP (Nota da Prova Prática)</option>
            <option value="NPT">NPT (Nota da Prova Teórica)</option>
            <option value="MT">MT (Média do Trimestre)</option>
        </select>
    </div>

    <div class="form-group" style="border: 1px solid #007bff; padding: 10px; border-radius: 6px;">
        <h4>Data de Início do Prazo</h4>
        <label>Mês de Início:</label>
        <select name="mes_inicio" required>
            <option value="">-- Mês --</option>
            <?php 
                $meses = [1=>'Janeiro',2=>'Fevereiro',3=>'Março',4=>'Abril',5=>'Maio',6=>'Junho',7=>'Julho',8=>'Agosto',9=>'Setembro',10=>'Outubro',11=>'Novembro',12=>'Dezembro'];
                foreach ($meses as $num => $nome) {
                    echo "<option value=\"$num\">$nome</option>";
                }
            ?>
        </select>
        <label>Dia inicial (1-31):</label>
        <input type="number" name="dia_inicio" min="1" max="31" required>
    </div>

    <div class="form-group" style="border: 1px solid #dc3545; padding: 10px; border-radius: 6px; margin-top: 15px;">
        <h4>Data de Fim do Prazo</h4>
        <label>Mês de Fim:</label>
        <select name="mes_fim" required>
            <option value="">-- Mês --</option>
            <?php 
                foreach ($meses as $num => $nome) {
                    echo "<option value=\"$num\">$nome</option>";
                }
            ?>
        </select>
        <label>Dia final (1-31):</label>
        <input type="number" name="dia_fim" min="1" max="31" required>
    </div>

    <button type="submit" style="margin-top: 20px;">Salvar Prazo</button>

</form>

</div>

</body>
</html>
